IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Rec_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Cbtes_Rec_Generar
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Rec_Generar] @pJson VARCHAR(8000)

AS
SET NOCOUNT ON
/*
 * LOG VERSIONES:
 * 13/09/2021: Se agrego Log de Versiones
 * 13/04/2022: Se agrego parametro Flag_LoteUnico
*/

/*Declaracion Variables Json*/

DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Usuario				SMALLINT
DECLARE @pId_Cliente				INT
DECLARE @pEmail						VARCHAR(50)
DECLARE @pId_Periodo_Caja		INT
DECLARE @pFecha						DATETIME
DECLARE @pImporte					DECIMAL(16,2)
DECLARE @pId_Tipo_Cbte			CHAR(4)
DECLARE @pId_Moneda				CHAR(3)
DECLARE @pCotizacion				DECIMAL(9, 4)
DECLARE @pId_Cobrador			VARCHAR(10)
DECLARE @pLote						VARCHAR(20)
DECLARE @pCbte_Nro_Externo	VARCHAR(25)
DECLARE @pFlag_LoteUnico	TINYINT						--12/04/2022 Agregado

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Cliente			= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')),0)
SET @pEmail					= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Email')), '')
SET @pId_Periodo_Caja		= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')),0)
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')),'19000101')
SET @pImporte				= ISNULL(CONVERT(DECIMAL(15,2), dbo.CF_JSON_VALUE(@pJson,'Importe')), 0)
SET @pId_Tipo_Cbte			= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cbte')), '')
SET @pId_Moneda				= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Moneda')), '')
SET @pCotizacion			= ISNULL(CONVERT(DECIMAL(12,4), dbo.CF_JSON_VALUE(@pJson,'Cotizacion')), 0)
SET @pId_Cobrador			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cobrador')), '')
SET @pLote					= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pCbte_Nro_Externo		= ISNULL(CONVERT(VARCHAR(25), dbo.CF_JSON_VALUE(@pJson,'Cbte_Nro_Externo')), '')
SET @pFlag_LoteUnico		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_LoteUnico')), 0)
/*Fin Declaracion Variables Json*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Trans					INT
DECLARE @Id_Empresa					SMALLINT
DECLARE @Id_Sucursal				SMALLINT
DECLARE @Cbte_Grupo					INT
DECLARE @Comprobante_Nro			INT
DECLARE @Id_Taller					VARCHAR(10)
DECLARE @Id_Proceso					VARCHAR(10)
DECLARE @Id_Proveedor				INT
DECLARE @Signo						SMALLINT
DECLARE @Id_Estado_Cbte				SMALLINT
DECLARE @Id_Dep_Fisico				CHAR(3)
DECLARE @Id_Dep_Logico				CHAR(3)
DECLARE @Porc_DescEspecial			DECIMAL(5, 2)
DECLARE @Porc_DescFin				DECIMAL(5, 2)
DECLARE @Porc_Bonificacion			DECIMAL(5, 2)
DECLARE @Porc_Iva					DECIMAL(5, 2)
DECLARE @Porc_Iva2					DECIMAL(5, 2)
DECLARE @Imp_Neto					DECIMAL(12, 2)
DECLARE @Imp_DescEspecial			DECIMAL(12, 2)
DECLARE @Imp_DescFin				DECIMAL(12, 2)
DECLARE @Imp_Bonificacion			DECIMAL(12, 2)
DECLARE @Imp_Gravado				DECIMAL(12, 2)
DECLARE @Imp_Exento					DECIMAL(12, 2)
DECLARE @Imp_IVA					DECIMAL(12, 2)
DECLARE @Imp_IVA2					DECIMAL(12, 2)
DECLARE @Imp_Percepcion_IB			DECIMAL(12, 2)
DECLARE @Imp_Percepcion_Iva			DECIMAL(12, 2)
DECLARE @Imp_Total					DECIMAL(12, 2)
DECLARE @Bultos						SMALLINT
DECLARE @NroImpresion				INT
DECLARE @Exportado					TINYINT
DECLARE @Fecha_Estimada				DATETIME
DECLARE @Dir_Entrega				VARCHAR(255)
DECLARE @Id_Pais						CHAR(3)
DECLARE @Id_Provincia				CHAR(3)
DECLARE @Id_Localidad				INT
DECLARE @Persona_Recibe				VARCHAR(100)
DECLARE @Porc_Iva3					DECIMAL(5, 2)
DECLARE @Imp_Gravado2				DECIMAL(12, 2)
DECLARE @Imp_Gravado3				DECIMAL(12, 2)
DECLARE @Imp_NoGravado				DECIMAL(12, 2)
DECLARE @Imp_IVA3					DECIMAL(12, 2)
DECLARE @Imp_Percep					DECIMAL(12, 2)
DECLARE @Saldo						DECIMAL(12, 2)
DECLARE @Periodo_Iva				DATETIME
DECLARE @Periodo					DATETIME
DECLARE @Fecha_Venc					DATETIME
DECLARE @Observacion				VARCHAR(8000)
DECLARE @Id_Cond_Pago_Item			TINYINT
DECLARE @Id_Cond_Pago				SMALLINT
DECLARE @Id_Tipo_Reten				VARCHAR(10)
DECLARE @Cant_Cuotas				SMALLINT
DECLARE @Id_Producto				VARCHAR(14)
DECLARE @Id_Formula					VARCHAR(15)
DECLARE @Cantidad					DECIMAL(12, 4)
DECLARE @Id_Vendedor				VARCHAR(10)
DECLARE @Id_Transportista			INT
DECLARE @Id_Lista					SMALLINT
DECLARE @Destinatario				VARCHAR(100)
DECLARE @Cuit						VARCHAR(19)
DECLARE @Id_Iva						CHAR(3)
DECLARE @Cant_Batch					SMALLINT
DECLARE @Nro_Perm_Embarque			VARCHAR(20)
DECLARE @Fecha_Perm_Embar			DATETIME
DECLARE @Saldo_Iva_Recup			DECIMAL(12, 2)
DECLARE @Suc_Destina				SMALLINT
DECLARE @Id_Puerto					CHAR(3)
DECLARE @Id_Cond_Vta				CHAR(10)
DECLARE @Cbte_Nro_Externo			VARCHAR(25)
DECLARE @Nota_Part1					VARCHAR(100)
DECLARE @Nota_Part2					VARCHAR(100)
DECLARE @Id_Asiento					INT
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Id_Valor					INT
DECLARE @Cai						DECIMAL(14, 0)
DECLARE @Cai_Vence					DATETIME
DECLARE @Des_Anio					TINYINT
DECLARE @Des_Aduana					CHAR(3)
DECLARE @Des_Destina				CHAR(4)
DECLARE @Des_Nro					INT
DECLARE @Des_Verif					CHAR(1)
DECLARE @Id_Contrato				INT
DECLARE @Id_Cobrador				VARCHAR(10)
DECLARE @Nro_Auto_Trib				VARCHAR(14)
DECLARE @Id_Camp					SMALLINT
DECLARE @Remito_Nro					VARCHAR(25)
DECLARE @Pedido_Nro					VARCHAR(25)
DECLARE @Id_Tarjeta					VARCHAR(11)
DECLARE @Tarjeta_Nro				VARCHAR(25)
DECLARE @Cantidad_Saldo				DECIMAL(12, 4)
DECLARE @Saldo_Anterior				DECIMAL(12, 2)
DECLARE @NRO_DJAI					VARCHAR(30)
DECLARE @Cantidad_Equiv				DECIMAL(12, 4)
DECLARE @Id_Trans_Origen			INT
DECLARE @Id_Sede_Origen				SMALLINT
DECLARE @Email						VARCHAR(8000)
DECLARE @Patente_Transporte			VARCHAR(7)
DECLARE @Patente_Transporte_Acoplado VARCHAR(7)

DECLARE @Flag_Existe_Cliente		TINYINT
DECLARE @Flag_Existe_Periodo_Caja	TINYINT
DECLARE @Flag_Existe_Cbte_Tipo		TINYINT
DECLARE @Flag_Existe_Moneda			TINYINT
DECLARE @Flag_Existe_Usuario		TINYINT
DECLARE @Flag_Lote					TINYINT

DECLARE @Plazo_Venc					SMALLINT
DECLARE @Renglon_Nro				SMALLINT
DECLARE @Id_Estado_Mov_Caja			INT
DECLARE @Descripcion				VARCHAR(100)
DECLARE @Id_Tipo_Mov_Caja			SMALLINT
DECLARE @Id_Concepto				INT
DECLARE @Item						SMALLINT
DECLARE @Id_Estado_Concepto			SMALLINT
DECLARE @Mensaje					VARCHAR(100)
DECLARE @Resultado					INT
DECLARE @Flag_Existe_Cbte_Lote		TINYINT
/*Fin de Declaraciones Variables Locales */

/*BLOQUE BEGIN TRY *************************************************************************************/
BEGIN TRY
	BEGIN TRAN

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Rec_Generar'
		PRINT 'Parametros:'	
		PRINT '.@pId_Cliente: ' + CONVERT(VARCHAR(10), @pId_Cliente)+ '.pEmail: ' + CONVERT(VARCHAR(MAX), @pEmail) + ' pFecha: ' + CONVERT(VARCHAR(10), @pFecha, 103) +'pImporte:  ' +CONVERT(VARCHAR(50),@pImporte) + 'pId_Tipo_Cbte: ' + @pId_Tipo_Cbte +  ' pId_Moneda: ' + @pId_Moneda + ' pCotizacion: ' + CONVERT(VARCHAR(20), @pCotizacion) + '. pLote: ' + @pLote + 'pCbte_Nro_Externo: ' + @pCbte_Nro_Externo
	END
	
	/*===================================================================================================================================================================*/

	--13/04/2022 Se agrega la utilizacion del parametro @pFlag_LoteUnico para poder validar que si ya se ingreso un pago WEB (Lote tipo P00XXXXXX) sea unico
	IF(@pFlag_LoteUnico = 1)
	BEGIN
		SET @Flag_Existe_Cbte_Lote = ISNULL((SELECT TOP 1 1
											FROM Cbtes CB, Cbtes_Tipos CT
											WHERE
											CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
											AND CT.Compromete_Recibos IN (1, -1)
											AND CB.Lote = @pLote)
											, 0) 
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Flag_Existe_Cbte_Lote: ' + CONVERT(VARCHAR(10), @Flag_Existe_Cbte_Lote)
		END

		IF(@Flag_Existe_Cbte_Lote = 1)
		BEGIN
			SET @Id_Trans		= 0

			SET @rtaMsjStored	=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @Id_Trans, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('id_cliente', 0, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('id_tipo_cbte', '', 'VARCHAR') +
									'}'
								
			SELECT	 0				AS ErrorNumber 
					,0				AS ErrorSeverity  
					,0				AS ErrorState 
					,0				AS ErrorProcedure  
					,@Id_Trans		AS ErrorLine		
					,@rtaMsjStored	AS ErrorMessage
		END
	END

	/*===================================================================================================================================================================*/

	/******************VALIDACIONES *************************************************************************/
  	
  	IF(@pId_Usuario	 =0) RAISERROR ('Id_Usuario can not be zero.',16,1)
  	IF(@pId_Cliente		 = 0) RAISERROR ('Id_Cliente can not be zero.', 16,  1 ) 
	IF(@pId_Tipo_Cbte	 = '') RAISERROR ('Id_Tipo_Cbte can not be blank.', 16,  1 ) 
	
	SET @Flag_Existe_Periodo_Caja = ISNULL((SELECT 1 FROM Cajas_Periodos WHERE Id_Periodo_Caja = @pId_Periodo_Caja AND Id_Estado_Caja = 1/*Abierta*/), 0)
	IF(@Flag_Existe_Periodo_Caja = 0) RAISERROR ('@Id_Periodo_Caja can not be zero.', 16,  1 ) 
	
	
	IF(@pId_Moneda = '')
	BEGIN
		SET @pId_Moneda = dbo.CF_xParam('Moneda_Nacional')
	END

	IF(@pCotizacion = 0)
	BEGIN
		SET @pCotizacion = 1
	END
	
	IF(@pLote <> '')
	BEGIN
		SET @Flag_Lote	= 1
	END
	ELSE
	BEGIN
		SET @Flag_Lote	= 0
	END
	/*FIN VALIDACIONES ****************************************************************************/	

	/*Cargo en transacciones *************************************************************************/
	
	SET @Id_Trans		= ISNULL((SELECT MAX(Id_Trans) + 1 FROM Transacciones), 0)
	INSERT INTO dbo.Transacciones 	(Id_Trans,	Descripcion,				Fecha_Mov, 	Id_Usuario)
							VALUES	(@Id_Trans,	'Apertura CPJ_Transacciones_Abrir',	GETDATE(), 	@pId_Usuario)


    /*Fin Cargo en transacciones ******************************************************************/
    
	/*Comienzo con seteo de variables *************************************************************/
	
	SET @pFecha				= (SELECT CONVERT(DATE, @pFecha))

	SELECT @Id_Sucursal			= ISNULL(Id_Sucursal, 0),
				@Cbte_Grupo			= ISNULL(Cbte_Grupo, 0),
				@Id_Cond_Pago		= ISNULL(Id_Cond_Pago, ''),
				@Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte, 0)
	FROM Cbtes_Tipos 
	WHERE Id_Tipo_Cbte = @pId_Tipo_Cbte

	SELECT @Destinatario	= ISNULL(Razon_Social, Apellido + ', ' + Nombre),
				@Id_Pais			= ISNULL(Id_Pais_Cob, ''),
				@Id_Provincia	= ISNULL(Id_Provincia_Cob, ''),
				@Id_Localidad	= ISNULL(Id_Localidad_Cob, 0),
				@Id_Lista			= ISNULL(Id_Lista_Precio, 0),
				@Cuit				= ISNULL(Cuit, ''),
				@Id_Iva				= ISNULL(Id_Iva, ''),
				@Id_Concepto	= ISNULL(Id_Concepto, 0)
	FROM Clientes
	WHERE Id_Cliente = @pId_Cliente

	IF(ISNULL(@pEmail, '') = '')
	BEGIN
			SET @Email	=  (SELECT ISNULL(Email_Cob, '') FROM Clientes WHERE Id_Cliente = @pId_Cliente)
	END

	SET @Comprobante_Nro		= 0		
	SET @Plazo_Venc				= (SELECT ISNULL(Plazo_Venc, 0) FROM Cbtes_Cond_Pago WHERE Id_Cond_Pago = @Id_Cond_Pago)
	SET @Fecha_Venc				= @pFecha --Siempre es la misma en Recibos, no se basa en Cond_Pago Dias_Venc	
	SET @Periodo_Iva				= @pFecha
	SET @Periodo					= @pFecha
	SET @Imp_Total				= @pImporte
	SET @Saldo						= @pImporte
	SET @Imp_Gravado			= @pImporte
	SET @Cbte_Nro_Externo		= @pCbte_Nro_Externo
	
	/*TO-DO: De aca para abajo por ahora por Default*/
	SET @Id_Cond_Vta			= ''
	SET @Id_Taller				= ''
	SET @Id_Proceso				= ''
	SET @Id_Proveedor			= 0
	SET @Signo					= 0
	SET	@Porc_DescFin			= 0
	SET @Id_Dep_Fisico			= ''
	SET @Id_Dep_Logico			= ''
	SET @Porc_DescEspecial		= 0
	SET @Porc_Bonificacion		= 0
	SET @Porc_Iva				= 0
	SET @Porc_Iva2				= 0
	SET @Imp_Neto				= 0
	SET @Imp_DescEspecial		= 0
	SET @Imp_DescFin			= 0
	SET @Imp_Bonificacion		= 0
	SET @Imp_Exento				= 0
	SET @Imp_Iva				= 0
	SET @Imp_Iva2				= 0
	SET @Imp_Percepcion_IB		= 0
	SET @Imp_Percepcion_Iva		= 0
	SET @Bultos					= 0
	SET @NroImpresion			= 0
	SET @Exportado				= 0
	--SET @Fecha_Estimada NULL
	SET @Dir_Entrega			= ''
	SET @Persona_Recibe			= ''
	SET @Porc_Iva3				= 0
	SET @Imp_Gravado2			= 0
	SET @Imp_Gravado3			= 0
	SET @Imp_NoGravado			= 0
	SET @Imp_IVA3				= 0
	SET @Imp_Percep				= 0
	SET @Observacion			= ''
	--SET @Id_Cond_Pago_Item	NULL
	SET @Id_Tipo_Reten			= ''
	SET @Cant_Cuotas			= 0
	--SET @Id_Producto			NULL
	--SET @Id_Formula			NULL
	SET @Cantidad				= 0
	SET @Id_Vendedor			= ''
	SET @Id_Transportista		= 0
	SET @Cant_Batch				= 0
	SET @Nro_Perm_Embarque		= ''
	--SET @Fecha_Perm_Embar
	SET @Saldo_Iva_Recup		= 0
	SET @Suc_Destina			= 0
	SET @Id_Puerto				= ''
	--SET @Cbte_Nro_Externo	= ''
	SET @Nota_Part1				= ''
	SET @Nota_Part2				= ''
	SET @Id_Asiento				= 0
	SET @Id_Centro_Costo		= ''
	SET @Id_Valor				= 0
	SET @Cai					= 0
	--SET @Cai_Vence NULL
	SET @Des_Anio				= 0
	SET @Des_Aduana				= ''
	SET @Des_Destina			= ''
	SET @Des_Nro				= 0
	SET @Des_Verif				= ''
	SET @Id_Contrato			= 0

	IF(@pId_Cobrador <> '')
	BEGIN
		SET @Id_Cobrador		= @pId_Cobrador
	END
	ELSE
	BEGIN
		SET @Id_Cobrador		= (SELECT ISNULL(Id_Cobrador, '') FROM Clientes WHERE Id_Cliente = @pId_Cliente)
	END

	SET @Nro_Auto_Trib			= ''
	SET @Id_Camp				= 0
	SET @Remito_Nro				= ''
	SET @Pedido_Nro				= ''
	SET @Id_Tarjeta				= ''
	SET @Tarjeta_Nro			= ''
	SET @Cantidad_Saldo			= 0
	SET @Saldo_Anterior			= 0
	SET @NRO_DJAI				= ''
	SET @Cantidad_Equiv			= 0
	SET @Id_Trans_Origen		= 0
	SET @Id_Sede_Origen			= 0
	--SET @Patente_Transporte NULL
	--SET @Patente_Transporte_Acoplado NULL	

	/*FIN de Seteo de variables *******************************************************/
	
	INSERT INTO dbo.Cbtes
	(Id_Trans,			Id_Empresa,			Id_Sucursal,
	Id_Tipo_Cbte,		Cbte_Grupo,			Comprobante_Nro,
	Id_Cliente,			Id_Taller,			Id_Proceso,
	Id_Proveedor,		Signo,				Id_Estado_Cbte,
	Fecha,				Id_Dep_Fisico,		Id_Dep_Logico,
	Porc_DescEspecial,	Porc_DescFin,		Porc_Bonificacion,
	Porc_Iva,			Porc_Iva2,			Imp_Neto,
	Imp_DescEspecial,	Imp_DescFin,		Imp_Bonificacion,
	Imp_Gravado,		Imp_Exento,			Imp_IVA,
	Imp_IVA2,			Imp_Percepcion_IB,	Imp_Percepcion_Iva,
	Imp_Total,			Bultos,				NroImpresion,
	Exportado,			Id_Usuario,			Fecha_Estimada,
	Dir_Entrega,		Id_Pais,			Id_Provincia,
	Id_Localidad,		Persona_Recibe,		Porc_Iva3,
	Imp_Gravado2,		Imp_Gravado3,		Imp_NoGravado,
	Imp_IVA3,			Imp_Percep,			Saldo,
	Periodo_Iva,		Periodo,			Fecha_Venc,
	Observacion,		Id_Cond_Pago_Item,	Id_Cond_Pago,
	Id_Tipo_Reten,		Cant_Cuotas,		Id_Producto,
	Id_Formula,			Cantidad,			Id_Vendedor,
	Id_Transportista,	Id_Lista,			Id_Moneda,
	Cotizacion,			Destinatario,		Cuit,
	Id_Iva,				Cant_Batch,			Nro_Perm_Embarque,
	Fecha_Perm_Embar,	Saldo_Iva_Recup,	Lote,
	Suc_Destina,		Id_Puerto,			Id_Cond_Vta,
	Cbte_Nro_Externo,	Nota_Part1,			Nota_Part2,
	Id_Asiento,			Id_Centro_Costo,	Id_Valor,
	Cai,				Cai_Vence,			Des_Anio,
	Des_Aduana,			Des_Destina,		Des_Nro,
	Des_Verif,			Id_Contrato,		Id_Cobrador,
	Nro_Auto_Trib,		Id_Camp,			Remito_Nro,
	Pedido_Nro,			Id_Tarjeta,			Tarjeta_Nro,
	Cantidad_Saldo,		Saldo_Anterior,		NRO_DJAI,
	Cantidad_Equiv,		Id_Trans_Origen,	Id_Sede_Origen,
	Email,				Patente_Transporte,	Patente_Transporte_Acoplado,
	Flag_Lote)
	VALUES
	(@Id_Trans,			@Id_Empresa,		@Id_Sucursal,
	SUBSTRING(@pId_Tipo_Cbte,1,4),	@Cbte_Grupo,		@Comprobante_Nro,
	@pId_Cliente,		@Id_Taller,			@Id_Proceso,
	@Id_Proveedor,		@Signo,				@Id_Estado_Cbte,
	@pFecha,			@Id_Dep_Fisico,		@Id_Dep_Logico,
	@Porc_DescEspecial,	@Porc_DescFin,		@Porc_Bonificacion,
	@Porc_Iva,			@Porc_Iva2,			@Imp_Neto,
	@Imp_DescEspecial,	@Imp_DescFin,		@Imp_Bonificacion,
	@Imp_Gravado,		@Imp_Exento,		@Imp_IVA,
	@Imp_IVA2,			@Imp_Percepcion_IB,	@Imp_Percepcion_Iva,
	@Imp_Total,			@Bultos,			@NroImpresion,
	@Exportado,			@pId_Usuario,		@Fecha_Estimada,
	@Dir_Entrega,		@Id_Pais,			@Id_Provincia,
	@Id_Localidad,		@Persona_Recibe,	@Porc_Iva3,
	@Imp_Gravado2,		@Imp_Gravado3,		@Imp_NoGravado,
	@Imp_IVA3,			@Imp_Percep,		@Saldo,
	@Periodo_Iva,		@Periodo,			@Fecha_Venc,
	@Observacion,		@Id_Cond_Pago_Item,	@Id_Cond_Pago,
	@Id_Tipo_Reten,		@Cant_Cuotas,		@Id_Producto,
	@Id_Formula,		@Cantidad,			@Id_Vendedor,
	@Id_Transportista,	@Id_Lista,			@pId_Moneda,
	@pCotizacion,		@Destinatario,		@Cuit,
	@Id_Iva,			@Cant_Batch,		@Nro_Perm_Embarque,
	@Fecha_Perm_Embar,	@Saldo_Iva_Recup,	@pLote,
	@Suc_Destina,		@Id_Puerto,			@Id_Cond_Vta,
	@Cbte_Nro_Externo,	@Nota_Part1,		@Nota_Part2,
	@Id_Asiento,		@Id_Centro_Costo,	@Id_Valor,
	@Cai,				@Cai_Vence,			@Des_Anio,
	@Des_Aduana,		@Des_Destina,		@Des_Nro,
	@Des_Verif,			@Id_Contrato,		@Id_Cobrador,
	@Nro_Auto_Trib,		@Id_Camp,			@Remito_Nro,
	@Pedido_Nro,		@Id_Tarjeta,		@Tarjeta_Nro,
	@Cantidad_Saldo,	@Saldo_Anterior,	@Nro_DJAI,
	@Cantidad_Equiv,	@Id_Trans_Origen,	@Id_Sede_Origen,
	@Email,				@Patente_Transporte,@Patente_Transporte_Acoplado,
	@Flag_Lote)

	/*****************************************************************************/

	SET @Renglon_Nro = 1
	SET @Id_Estado_Mov_Caja = 0 --EN CARGA
	SET @Descripcion = ISNULL((dbo.CF_Cbte_Descrip(@Id_Trans)), '')
	SET @Id_Tipo_Mov_Caja = 7 --RECIBO DE COBRANZA

	INSERT INTO dbo.Cajas_Mov
			(Id_Trans,			Renglon_Nro,	Id_Estado_Mov_Caja,
			Importe,			Descripcion,	Id_Periodo_Caja,
			Id_Tipo_Mov_Caja,	Fecha)
			VALUES
			(@Id_Trans,			@Renglon_Nro,	@Id_Estado_Mov_Caja,
			@pImporte,			@Descripcion,	@pId_Periodo_Caja,
			@Id_Tipo_Mov_Caja,	GETDATE()/*Es con hora*/)

	/*****************************************************************************/

	SET @Item = 1
	SET @Id_Estado_Concepto = 0
	
	INSERT INTO dbo.Cajas_Mov_Conceptos
			(Id_Trans,						Id_Concepto,			Item,
			Id_Estado_Concepto,		Importe,				Id_Periodo_Caja)
			VALUES
			(@Id_Trans,					@Id_Concepto,		@Item,
			@Id_Estado_Concepto,	@pImporte * (-1),	@pId_Periodo_Caja)

	/*****************************************************************************/
	
	UPDATE Transacciones SET Descripcion = @Descripcion WHERE Id_Trans = @Id_Trans

	/*****************************************************************************/
	
	COMMIT

	--SET @Mensaje = @Descripcion

	--SELECT	 0				AS ErrorNumber 
	--		,0				AS ErrorSeverity  
	--		,0				AS ErrorState 
	--		,0				AS ErrorProcedure  
	--		,@Id_Trans		AS ErrorLine		
	--		,@Mensaje		AS ErrorMessage
	--		--,@Id_Trans		AS Id_Trans
	
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_trans', @Id_Trans, 'INT')  + ',' +
								dbo.CF_Json_ParsearVariable('id_cliente', @pId_Cliente, 'INT')  + ',' +
								dbo.CF_Json_ParsearVariable('id_tipo_cbte', @pId_Tipo_Cbte, 'VARCHAR') +
								'}'
								
	SELECT	 0						AS ErrorNumber 
				,0						AS ErrorSeverity  
				,0						AS ErrorState 
				,0						AS ErrorProcedure  
				,@Id_Trans		AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Rec_Generar'
	END	
	
END TRY  


BEGIN CATCH  

    EXECUTE usp_GetErrorInfo; 
	ROLLBACK
	RETURN 9999
END CATCH


RETURN 0
